AppName$="Multi-Tasker Demo"
 AppVer$="0.3.0" ' Attempt at instantiation & Process table
 Author$="User 'flip' @ TheBackshed.com forum"
 AppDate$="07-11-2017"  ' First Demo written back in August 2017 and posted on the forum
 ' Nested includes
 ' Escaping (uses double$ to allow subsequent source files to be produced without being processed - e.g. for full installer including source files
 ' Variables value assignment at Source-File load time in form $[VarName]=whatever
 ' Pre-defined variables:
 ' [FILE],[FILEROOT] - (without last .ext),[FILEEXT],[DIR] - aka Path, aka Folder,[DATE],[TIME],[LINE] - src file's line number
 
 'Issues
    '7/11/2017 Minor maybe not a bug - re-processing file every time source file is loaded -may be handy for re-defining build-time variables - does nothing at the moment
  'Needs & Wants
    'Create target directory if non-existent
    'Includes can be sourced from $[IncludeDir] parameter if NOT found in current directory
    'Wild-cards for $INCLUDE metacommand - 
    'Help
    'Command-line-interface (CLI) parameters (already accepts 'target' and 'src-file')
        '/i (interactive mode (i.e. GUI with logs to screen, info)
        '/t (Tests for builder)
        '/r (run if successfully built
        '/v (verbose comments)
        '/l (logging)
        '/[DEBUG]=Y  (i.e. setting global meta-variables)
    'Settings/Preferences (INI file?) or MMIDE.MMDB
        'Default CLI parameters
        'Preferred MMBASIC.EXE file
        '
    'Fully Test double escape
 Colour 15,0
 ? AppName$" ver "AppVer$"("AppDate$") written by "Author$
 ? "Program started at "Date$" "Time$
 Colour 6,0
? "Intro completed. ";
Option EXPLICIT
 Option DEFAULT NONE
 Const NUL=Chr$(0)
 Const BEL=Chr$(7)
 Const MAX_CTL=50
 ' Control type info
  Const CT_UNDEF=0
  Dim As INTEGER CT_FRAME '=1
  Dim As INTEGER CT_TEXTBOX '=2
  Dim As INTEGER CT_LABEL '=3
  Dim As INTEGER CT_F_KEYS =4
  Dim As INTEGER CT_cnt '=4
  Const MAX_CT=31 'Allow for up to 6 custom extention classes ExtCls01-ExtCls06
  Dim As STRING K_Flags(MAX_CT) LENGTH 20 ' 1 bit / char Chr$(0)-Chr$(160) (see MMBasic for DOS manual for keycodes
  Const MAX_CT_NAME_LENGTH=8
  Dim As STRING ct_names '(MAX_CT) Length MAX_CT_NAME_LENGTH
 Const K_F1=145,K_F2=146,K_F3=147,K_F6=150
 Const K_F12=156
 Const K_ESC=27
 Const K_TAB=9
 Const K_INS=132
 ' The key flags correspond to event-trigerrable keys
 'String allocation
 Const MAX_TEXT=100
 Dim As STRING Text(MAX_TEXT)
 Dim As INTEGER sPtr
 'Typical instance control data consists of:
 ' type,Caption,x,y,w,h,border,cFore,cBak,cbFore,cbBak,chFore,chBak,ArrayPointer
 Dim As INTEGER _ct(MAX_CTL) ' control type.. can be integer corresponding to CT_FRAME, CT_TEXT, CT_EDIT, as assigned by Register routine
 Dim As STRING _c(MAX_CTL) LENGTH 60 ' Captions... MAXIMUM LENGTH of CAPTION can be Adjusted here
 Dim As STRING _sb(MAX_CTL) LENGTH 120 ' StatusBar... MAXIMUM LENGTH of STATUS can be Adjusted here
 Dim As FLOAT _dx(MAX_CTL) ' x-posn of all controls
 Dim As FLOAT _dy(MAX_CTL) ' y-posn
 Dim As FLOAT _dw(MAX_CTL) ' defined width
 Dim As FLOAT _dh(MAX_CTL) ' height
 Dim As INTEGER _b(MAX_CTL) ' Border (0=None,1=Single,2=Double,3=Space,4=+,5=*)
 Dim As INTEGER _cf(MAX_CTL) ' foreground (fg) colour
 Dim As INTEGER _cb(MAX_CTL) ' background (bg) colour
 Dim As INTEGER _bf(MAX_CTL) ' border fg colour
 Dim As INTEGER _bb(MAX_CTL) ' border bg colour
 Dim As INTEGER _hf(MAX_CTL) ' hilite fg colour
 Dim As INTEGER _hb(MAX_CTL) ' hilite bg colour
 Dim As INTEGER _ap(MAX_CTL) ' array pointers into TEXT() array
 Dim As INTEGER _ts(MAX_CTL) ' Tab-stop (focusable)
 Dim As STRING _fk(12) LENGTH 40 ' 12 function keys: MAXIMUM LENGTH of FKey Text can be Adjusted here
 'Working variables
 Dim As INTEGER _x(MAX_CTL)
 Dim As INTEGER _y(MAX_CTL)
 Dim As INTEGER _w(MAX_CTL)
 Dim As INTEGER _h(MAX_CTL)
 Dim As INTEGER CurrCtl
 Dim AS INTEGER _cp(MAX_CTL) 'Cursor Positions
 Dim As INTEGER _cx(MAX_CTL) 'Cursor x/y positions
 Dim As INTEGER _cy(MAX_CTL) 'Cursor x/y positions
 Dim As INTEGER _cc(MAX_CTL) 'Current Character under cursor
 Dim As INTEGER _o(MAX_CTL) 'Current Offset (start position) of text in a control
 Const MAX_UDEFINTS=10
 Dim As INTEGER _udi(MAX_UDEFINTS,MAX_CTL)
' Real-Time & times Tasks
 Dim rt_fast$ 'Real-time FAST task list: each char is a task - all will be run each base scan
 Dim rt_nice$ 'Real-time NICE task list: each char is a task one will be run each base scan
 Dim ovr% ' Insert Mode is default as ovr% = 0 by default
 'Dim As Integer _wF 'Working foreground colour of currently active control
 'Dim As Integer _wB 'Working background
 Dim As INTEGER CurrFrame
 Dim As STRING Debug
 Dim As INTEGER NumCtls
'GP Routines
FUNCTION Ltrim$(sTxt AS STRING, sChrs AS STRING)
 LOCAL AS INTEGER i
 LOCAL AS STRING sChs=sChrs
  IF sChs="" THEN sChs=" "+CHR$(0)+CHR$(8)
  For i=1 TO LEN(sTxt)
    IF INSTR(sChs,MID$(sTxt,i,1))=0 THEN
      Ltrim$=MID$(sTxt,i)
      EXIT FUNCTION
    ENDIF
  NEXT i
END FUNCTION
FUNCTION Rtrim$(sTxt AS STRING, sChrs AS STRING)
 LOCAL AS INTEGER i
 LOCAL AS STRING sChs=sChrs
  IF sChs="" THEN sChs=" "+CHR$(0)+CHR$(8)
  For i=LEN(sTxt) TO 1 STEP -1
    IF INSTR(sChs,MID$(sTxt,i,1))=0 THEN
      Rtrim$=LEFT$(sTxt,i)
      EXIT FUNCTION
    ENDIF
  NEXT i
END FUNCTION
FUNCTION Trim$(sTxt AS STRING, sChrs AS STRING) AS STRING
  Trim$=Ltrim$(Rtrim$(sTxt, sChrs), sChrs)
END FUNCTION
Function ChReplace$(x$,a$,b$)
 Local f%,p%
  ChReplace$=x$
  Do
    p%=Instr(p%+1,ChReplace$,a$)
    If p%>0 Then
      ChReplace$=Left$(ChReplace$,p%-1)+b$+Mid$(ChReplace$,p%+Len(a$))
      p%=p%+Len(b$)-1
    Else
      Exit Do
    EndIf
  Loop
End Function
Dim dfltdelim$=NUL 'Used by GetField$
FUNCTION GetField$(rc$,fld%,delim$)
 LOCAL AS INTEGER p1
 LOCAL AS INTEGER p2
 LOCAL AS INTEGER c
  IF delim$="" THEN delim$=dfltdelim$ 'if not provided
  IF delim$="" THEN delim$="," 'if no default, use comma
  DO WHILE p2<LEN(rc$)
    c=c+1
    p2=INSTR(p1+1,rc$,delim$)
    if p2=0 then p2=LEN(rc$)+1
    IF c=fld% THEN
      GetField$=MID$(rc$,p1+1,p2-p1-1)
      EXIT FUNCTION
    ENDIF
    p1=p2
  LOOP
END FUNCTION
'Window routines
Dim As INTEGER MMHRES=MM.HRES
Function ScreenDimChanged() As INTEGER
 Local hp%,i%
  For i%=1 to 4000
    Cursor i%,0
    hp%=Pos
    If hp%<i% Then Exit For
  Next i%
'  ? hp%,i%
'  end
  If i%-2 <> MMHRES Then
    MMHRES=i%-2
    ScreenDimChanged=1
  EndIf
End Function
Sub RePaint
 'TODO: Down the track change this so it just sets all values in flag array String$(NumCtls\8 +1,255)
 ' one string-flag-array for frames other for controls for maximum granularity
 'Leave the actual update to a Timer tick with a grace tick between each update?? i.e. be nice...'niceness' of RePaint could be a setting
  Local As INTEGER c
  Colour 7,0
  'Cls
  For c=1 To NumCtls
    Select Case _ct(c)
    Case CT_TEXTBOX, CT_FRAME, CT_LABEL: DrawFrame c
    Case CT_F_KEYS: DrawF_Keys c
    Case Else: ? "Repaint control-type undefined:";_ct(c);" - This can't happen"
    End Select
  Next c
 ' Colour 0,0 'Turn off cursor trick doesn't work
  Cursor MMHRES,MM.VRES
End Sub
Sub FocusNextControl
 Local swp%,i%
  i%=CurrCtl
  If i%>0 Then ' Un-highlight currently focused object
    swp%=_cf(i%):_cf(i%)=_hf(i%):_hf(i%)=swp%
    swp%=_cb(i%):_cb(i%)=_hb(i%):_hb(i%)=swp%
    CurrCtl=0
    DrawFrame i%
  EndIf
  Do ' Look for the next focusable object,
    i%=i%+1: If i%>NumCtls Then i%=1
    If _ts(i%)>0 Then 'found - highlight it
      swp%=_cf(i%):_cf(i%)=_hf(i%):_hf(i%)=swp%
      swp%=_cb(i%):_cb(i%)=_hb(i%):_hb(i%)=swp%
      CurrCtl=i%
      DrawFrame i%
      Exit Do
    EndIF
  Loop While i%<>CurrCtl
End Sub
Sub KeyPress(k$,i%) '(i% is optional)
  If i%=0 Then i%=CurrCtl: If i%=0 Then ? BEL;:Exit Sub
  Local p%=_cp(i%)
  Local As Integer MAXP=_w(i%) * _h(i%)
  Local wk$= Text(_ap(i%))
    SELECT Case Asc(k$)
      CASE 130: p%=p%-1: IF p%<0 THEN p%=0: ? CHR$(7); 'Left
      CASE 131: p%=p%+1: IF p%>LEN(wk$) THEN p%=LEN(wk$): ? CHR$(7); 'Right
      CASE 134: p%=0:_o(i%)=0 'Home
      CASE 135: p%=LEN(wk$) 'End
      'CASE 13: EditLine$=wk$:? CHR$(13);pre$;wk$;: EXIT FUNCTION 'Enter
      'CASE 27: EditLine$=s$:? CHR$(13);s$+SPACE$(MAXW-LEN(s$));CHR$(13);pre$;s$;:EXIT FUNCTION 'Esc
      CASE 8 'BackSpace
        IF p%>0 THEN
          if p%<255 then
            wk$=LEFT$(wk$,p%-1) + MID$(wk$,p%+1)
          Else
            wk$=LEFT$(wk$,p%-1)
          EndIf
          p%=p%-1
        ELSE
          ? CHR$(7);
        ENDIF
      CASE 127 'Del
        IF p%<LEN(wk$) THEN
          wk$=LEFT$(wk$,p%) + MID$(wk$,p%+2)
        ELSE
          ? CHR$(7);
        ENDIF
      CASE 128 'K_UP
        p%=p%-_w(i%): IF p%<0 THEN ? BEL;: p%=p%+_w(i%)
      Case 129 'K_DN
        p%=p%+_w(i%)
        IF p%>MAXP And p%>Len(wk$) THEN
          ? BEL;: p%=p%-_w(i%)
        ElseIf p%>MAXP Then
          _o(i%)=_o(i%)+_w(i%)
        EndIf
      CASE 32 To 126
        If Len(wk$)>=MAXP Or Len(wk$)=255 Then
          ? BEL;
        Else
          wk$=LEFT$(wk$,p%) + k$ + MID$(wk$,p%+1+ovr%)
          p%=p%+1
        EndIf
      Case Else 'currently unprocessable character
        ? BEL;
    END SELECT
  _cp(i%)=p%
  Text(_ap(i%))=wk$
  DisplayStr i%
End Sub
Sub PrintLong(n%,ch$)
  For i%= 1 to n%\255
    ? String$(255,ch$);
  Next i%
  If n%>0 Then ? String$(n% MOD 255,ch$);
End Sub
Sub DisplayStr(i%)
 Local ptr%=_ap(i%)
 Local l% ' Line ptr
  If ptr%<1 Then Exit Sub'ptr%>0 Then
    Local x%=_x(i%)
    Local y%=_y(i%)
    Local w%=_w(i%)
    Local h%=_h(i%)
    Local cf%=_cf(i%)
    Local cb%=_cb(i%)
    Local sz%=w%*h%
    If sz%>255 Then sz%=255
    If w%>255 Then w%=255
    Local s$=Mid$(Text(ptr%),_o(i%)+1)
    s$=Left$(s$,sz%)
'    ? chr$(13);len(s$);
    s$=s$+Space$(sz%-Len(s$))
    Colour cf%,cb%
    For l%=1 to h%
      Cursor x%+1,y%+l%
      If (l%-1)*w%+1<256 Then ? Mid$(s$,(l%-1)*w%+1,w%);
    Next l%
    '? len(s$);
'  EndIf
  ' Set the cursor position
  Local cp%=_cp(i%)
  If i%=CurrCtl Then
    If cp%=sz% Then cp%=cp%-1
    If cp%<sz% Then
      Debug="DBG:"+Str$(cp%)+";"
      _cx(i%)= x% + cp% MOD w%+1
      _cy(i%)= y% + cp%\w%+1
      _cc(i%)= Asc(Mid$(s$,cp%+1))
    EndIf
  EndIf
  Cursor MMHRES,MM.VRES
End Sub
Sub DrawFrame(i%) ' and contents (may eventually call DisplayStr)
 Local As FLOAT w=_dw(i%)
  If w<=0 Then w=CurrW+w
  If w<>Int(w) and w<1 Then w=Int(CurrW*w+0.5)
  _w(i%)=w
  Local x%=_dx(i%)
  If x%<0 Then x%=CurrW+x%-w
  _x(i%)=x%
  Local y%=_dy(i%)
  If y%<0 Then y%=CurrH+y%
  _y(i%)=y%
  Local c$=_c(i%)
  Local sb$=_sb(i%)
  Local As FLOAT h=_dh(i%)
  If h<=0 Then h=CurrH+h
  If h<>Int(h) and h<1 Then h=Int(CurrH*h+0.5)
  _h(i%)=h
  Local cf%=_cf(i%)
  Local cb%=_cb(i%)
  Local bf%=_bf(i%)
  Local bb%=_bb(i%)
  Local brdr%=_b(i%)
  Local As String xtra=" *"+Chr$(219)
  Local As String vl=Mid$(Chr$(179)+Chr$(186)+xtra+"|",brdr%,1) ' vert.line
  Local As String tl=Mid$(Chr$(218)+Chr$(201)+xtra+"+",brdr%,1) ' top-left
  Local As String tr=Mid$(Chr$(191)+Chr$(187)+xtra+"+",brdr%,1) ' top-right
  Local As String bl=Mid$(Chr$(192)+Chr$(200)+xtra+"+",brdr%,1) ' bottom-left
  Local As String hl=Mid$(Chr$(196)+Chr$(205)+xtra+"-",brdr%,1) ' horiz.line
  Local As String br=Mid$(Chr$(217)+Chr$(188)+xtra+"+",brdr%,1) ' bottom-right
  Local As String rd=Mid$(Chr$(180)+Chr$(185)+xtra+"<",brdr%,1) ' Right divider
  Local As String ld=Mid$(Chr$(195)+Chr$(204)+xtra+">",brdr%,1) ' left-divider
  Local As String sp=" "
  Local l% ' lines being drawn
  Local ptr%=_ap(i%)
  Local sz%=w*h
   If sz%>255 Then sz%=255
 Local s$
  If ptr% Then 
    s$=Left$(Text(ptr%),sz%)
  EndIf
  Cursor x%,y%
  Colour bf%,bb%
  Cursor x%,y%
  s$=Left$(s$,sz%)
  s$=s$+Space$(sz%-Len(s$))
  ? tl;
  If Len(c$) Then
    Print rd;
    Colour cf%,cb%
    ? c$;
    Colour bf%,bb%
    ? ld; 'w;" ";Len(c$);
    PrintLong w-Len(c$)-2,hl
  Else
    PrintLong w,hl
  EndIf
  ? tr
  For l%=1 To h
    Cursor x%,y%+l%
    ? vl;
    Colour cf%,cb%
    If (l%-1)*w+1<256 Then
      if w<256 Then
        ? Mid$(s$,(l%-1)*w+1,w);
      Else
        ? s$;
        PrintLong w-Len(s$)-2," "
      EndIf
      If Len(s$)<l%*w Then PrintLong(l%*w-Len(s$)," ");
    Else
      PrintLong w," "
    EndIf
    Colour bf%,bb%
    ? vl;
  Next l%
  Cursor x%,y%+h+1
  ? bl;
  If Len(sb$) Then
    If Len(sb$)<w-1 Then
      ? rd;
      ? sb$;
      ? ld;
      PrintLong w-Len(sb$)-2,hl
    Else
      ? Left$(sb$,w+1);
    EndIf
  Else
    PrintLong w,hl
  EndIf
  If (y%+h<MM.VRES-1 Or x%+w<MMHRES-1) And Len(sb$)<(w+1) Then
     If Len(sb$)=w-1 Then ? hl;
     ? br;
  EndIf
  If i%=CurrCtl Then
    Local cp%=_cp%(i%)
    Debug="DBG:"+Str$(cp%)+";"
      _cx(i%)= x% + cp% MOD w+1
      _cy(i%)= y% + cp%\w+1
      If cp%=255 Then
        _cc(i%)=32 'Space
      Else
        _cc(i%)= Asc(Mid$(s$,cp%+1))
      EndIf
    EndIf
  If _ct(i%)=CT_FRAME Then CurrFrame=i%
  Cursor MMHRES,MM.VRES
End Sub
Sub DrawSB(i%)
 Local x%=_x(i%)
 Local y%=_y(i%)
 Local w%=_w(i%)
 Local h%=_h(i%)
 Local sb$=_sb(i%)
 Local bf%=_bf(i%)
 Local bb%=_bb(i%)
 Local brdr%=_b(i%)
 Local As String xtra=" *"+Chr$(219)
 Local As String bl=Mid$(Chr$(192)+Chr$(200)+xtra+"+",brdr%,1) ' bottom-left
 Local As String hl=Mid$(Chr$(196)+Chr$(205)+xtra+"-",brdr%,1) ' horiz.line
 Local As String br=Mid$(Chr$(217)+Chr$(188)+xtra+"+",brdr%,1) ' bottom-right
 Local As String rd=Mid$(Chr$(180)+Chr$(185)+xtra+"<",brdr%,1) ' Right divider
 Local As String ld=Mid$(Chr$(195)+Chr$(204)+xtra+">",brdr%,1) ' left-divider
  Colour bf%,bb%
  Cursor x%,y%+h%+1
  ? bl;
  If Len(sb$) Then
    If Len(sb$)<w%-2 Then
      ? rd;
      Colour bb%,bf%
      ? sb$;
      Colour bf%,bb%
      ? ld;
      PrintLong w%-Len(sb$)-2,hl
    Else
      ? Left$(sb$,w%+1)
    EndIf
    
  Else
    PrintLong w%,hl
  EndIf
  If y%+h%<MM.VRES-1 Or x%+w%<MMHRES-1 Then ? br;
  Cursor MMHRES,MM.VRES
End Sub
Sub DrawF_Keys(i%)
 ' FKeys control,x,y,w,h,cFore,cBak,captions
 Local f$
 Local k% 'FKey Loop counter
 Local l% ' line loop counter
 Local fh%=_h(i%) 'height
  If fh%<1 Then 'set some reasonable limits to height
    fh%=1
  ElseIf fh%>4 Then
    fh%=4
  EndIf
 Local fw%=(MMHRES-3)\12-1 'Adjust for 2 gaps
 Local o%=(MMHRES-(fw%+1)*12-1)\2
 Local fs%=fw%*fh%
 Colour _cf(i%),_cb(i%)
 For k%=0 to 11
    f$=Left$(_fk(k%+1),fs%)
    If Len(f$)>0 Then
      f$=f$+String$(fw%*fh%-Len(f$),Chr$(255))
      For l%=0 to fh%-1
        Cursor 1+k%*(fw%+1)+o%*(k%\4),MM.VRES-fh%+l%
        ? Mid$(f$,fw%*l%+1,fw%);
      Next l%
     EndIf
  Next k% 
'  End
  Color 7,0
End Sub
'Initialisation
Dim As INTEGER giTickRate 
Dim As INTEGER giIPS 'Instructions-per-second (simple Instructions)
Sub SetTickPerformance  'set giTickRate As Integer based on actual measurement
  Local y%=timer
  Local x% 'distinct timer mS granularity
  Local m% 'mS loop counter
  Do:Loop Until y%<>Timer
  Local tv%(999)
  giIPS=0
  Do
    x%=TIMER Mod 1000
    tv%(x%)=tv%(x%)+1
    giIPS=giIPS+1
  Loop Until TIMER>y%+1000
  For m%=0 To 999
    If tv%(m%)>0 Then giTickRate=giTickRate+1
  Next m%
  giIPS=giIPS*4
End Sub
Sub Register(cl_name As STRING,clID As INTEGER, NoCreate As INTEGER) 'As STRING ' Maybe later Returns zero-length string if all OK
  Local As STRING cln=Trim$(cl_name)
  If Len(cln)=0 Then ? "Supplied class name is empty": End
  clID=(Instr(NUL+Ucase$(ct_names),NUL+Ucase$(cl_name)+NUL)+MAX_CT_NAME_LENGTH)\(MAX_CT_NAME_LENGTH+1)
  If clID Then
    If NoCreate=0 Then
      ? "Warning: Class name '"cl_name"' already registered as #"clID:Pause 2000
    EndIf
  ElseIf 255-Len(ct_names)<(MAX_CT_NAME_LENGTH+1) Then
    ? "Fatal, too many classes to register"
    ? ct_names
    End
  Else 'we're OK to add
    If NoCreate Then
        ? "Fatal, Class '"cl_name"' not registered"
        End
    EndIf
    ct_names=ct_names+cln+String$(MAX_CT_NAME_LENGTH+1-Len(cln),NUL)
    CT_cnt=CT_cnt+1
    clID=CT_cnt
  EndIf
End Sub
Function sAlloc(ctlID As INTEGER,NumStrings As INTEGER) As INTEGER
 'String Allocationto an object instance.
 'ctlID is mandatory and must be beteen 1 and 255(or MAX_CTL-whichever is smaller)
 'NumStrings is optional (defaults to 1 if 0 or omitted)
 '  ...can be negative to Deallocate (may end up wrapping with/Separating into sDeAlloc function
 'returns array-pointer if done, 0 if deallocated, -ve represents the number of strings unable to allocate
 Local i%
 Local sCnt%=NumStrings
 If ctlID<1 or ctlID>255 or ctlID>MAX_CTL Then ? "sAlloc can only handle control IDs beteen 1 and 255(or MAX_CTL-whichever is smaller)":End
 If sCnt%=0 Then sCnt%=1
' ? "allocating "sCnt%" string(s) to ctlID "ctlID;"..."
 If sCnt% <0 Then  ' De-Allocate from the end backwards
  For i%=sPtr to Step -1
    If Asc(Mid$(Text(0),i%,1))=ctlID And sCnt<0 Then
      Text(0)=Left$(Text(0),i%-1)+NUL+Mid$(Text(0),i%+1)'De-select flag
      sCnt=sCnt+1
    EndIf
  Next i%
 Else 'Allocate string space
  For i%=1 to MAX_TEXT
    If Mid$(Text(0),i%,sCnt%)=String$(sCnt%,NUL) Then
      If sCnt%>0 Then
        Text(0)=Left$(Text(0),i%-1)+String$(sCnt%,Chr$(ctlID))+Mid$(Text(0),i%+sCnt%)'Assign flag(s)
        sAlloc=i%
        Exit Function
      Else
        Exit For
      EndIf
    EndIf
  Next i%
 EndIf
 sAlloc=-sCnt%
End Function
'Instantiation? to be completed soon
Function Create(odef As STRING) As STRING
    Local i%
    If Len(odef)=0 Then Exit Function  ' Done reading in controls
    NumCtls=NumCtls+1
    Local a$=odef
    a$=ChReplace$(Mid$(a$,2),Left$(a$,1),NUL) ' First character is deimiter
    Local As INTEGER ctID 
    Local As STRING ctnm=GetField$(a$,1)
    Register ctnm, ctID, 1 'Tokenise control types
    If ctID=0 Then ? "FATAL: Class typename '"ctnm"' doesn't exist":End
    _ct(NumCtls)=ctID
'   ? ctnm$,ctID: Pause 2000
'   ? "CT_F_KEYS is"CT_F_KEYS
    Select Case ctID
    Case CT_FRAME
        If CurrFrame=0 Then CurrFrame=NumCtls 'Can be superseded by the Application if need be
    Case CT_F_KEYS
'       CLS:? "F-Keys":Pause 5000
        For i%=1 to 12
          _fk(i%)=GetField$(a$,i%+4)
        Next i%
      _h(NumCtls)=Val(GetField$(a$,2)) 'Height is Field#6
      _cf(NumCtls)=Val(GetField$(a$,3)) 'Foreground colour
      _cb(NumCtls)=Val(GetField$(a$,4)) 'background
 '     Case Else : ? "Error undefined control-type:";b$
    End Select
    If _ct(NumCtls)<>CT_F_KEYS Then
      _c(NumCtls)=GetField$(a$,2) 'Caption is Field#2
      _dx(NumCtls)=Val(GetField$(a$,3)) 'x.pos is Field#3
      _dy(NumCtls)=Val(GetField$(a$,4)) 'y.pos is Field#4
      _dw(NumCtls)=Val(GetField$(a$,5)) 'Width is Field#5
      _dh(NumCtls)=Val(GetField$(a$,6)) 'Height is Field#6
      _b(NumCtls)=Val(GetField$(a$,7)) 'BorderStyle is Field#7
      _cf(NumCtls)=Val(GetField$(a$,8)) 'Foreground colour
      _cb(NumCtls)=Val(GetField$(a$,9)) 'background
      _bf(NumCtls)=Val(GetField$(a$,10)) 'border-fore
      _bb(NumCtls)=Val(GetField$(a$,11)) 'border-back
      _hf(NumCtls)=Val(GetField$(a$,12)) 'hilite fore
      _hb(NumCtls)=Val(GetField$(a$,13)) 'hilite back
      _ts(NumCtls)=Ucase$(GetField$(a$,14))="Y" 'tab-stoppable (not implemented yet)
      i%=Val(GetField$(a$,15))
      If i%>0 Then _ap(NumCtls)=sAlloc(NumCtls,i%) 'Array pointer into Text()
    EndIf
    Create=Str$(NumCtls)
End Function
Sub InitControls
  Local a$,b$,i%,reslt$
  Text(0)=String$(255,NUL) 'flag array used by sAlloc routine
  ' Format of DATA record (except Fkeys) as follows:
  '<delim-chr>type,Caption,x,y,w,h,border,cFore,cBak,cbFore,cbBak,chFore,chBak,Tab-stop-able,ArrayPointer
  'Frame should be the first control...until I set up default (which will be control #0)
  ' Format of DATA record (except Fkeys) as follows:
  '<delim-chr>type,Caption,x,y,w,h,border,cFore,cBak,cbFore,cbBak,chFore,chBak,Tab-stop-able,ArrayPointer
  'Frame should be the first control...until I set up default (which will be control #0)
  reslt$=Create(",Frame,MM Basic for DOS - SMT_Test.APP - (Press <F12> to Exit),0,0,0,0,1,14,0,7,0,N,0") 'Width and height become CurrW-1 and CurrH-1)
  reslt$=Create(",TextBox,Scribble Box 1,1,7,33,4,1,14,1,2,0,1,14,Y,1") '1
  Text(_ap(Val(reslt$)))="This is some text in an Edit Text Box...Tab to me and try typing"
  reslt$=TS_Create(",Label,Auto-Scroller,37,8,0.4,3,2,6,0,13,0,0,6,Y,1") '2
 Local As INTEGER TS_i,ctlID
 ctlID=val(reslt$)
 ' ? "Text Scroller is CtlID";ctlID: pause 5000
  For TS_i=32 to 126
    Text(_ap(ctlID))=Text(_ap(ctlID))+Chr$(TS_i)
  Next TS_i
  Text(_ap(ctlID))=Text(_ap(ctlID))+Text(_ap(ctlID))
  reslt$=Create(",TextBox,Scribble Box 2,2,13,0.7,0.1,6,5,0,12,0,15,5,Y,1") '3
  Text(_ap(Val(reslt$)))= "":For i%=65 to 89:Text(_ap(Val(reslt$)))=Text(_ap(Val(reslt$)))+String$(10,Chr$(i%)):Next i%
  reslt$=Create(",Label,Width Height,-2,-9,14,2,5,11,0,11,0,,,N,1") '4
  reslt$=Create(",Label,Performance,1,-5,-3,1,1,6,0,11,0,,,N,1") '5
  
  ' FKeys control,h,cFore,cBak,captions
  reslt$=Create(",F-Keys,2,1,14,Help(one day),Start/Stop Scroller,Scroller Fast/Normal,F-Key 4,F-Key 5,F6=RePaint,F7,F8,F-Key 9,F-Key 10,Full-Screen,Quit Program")
  Local As STRING x
  reslt$=Create(",Label,About...,4,1,57,4,1,6,0,11,0,,,N,1")
  x="(1)Resize DOS box use Mouse & F11:Note Cyan Width+Height.(2)F2&F3 to stop/start/speed Auto-Scroller:Note the perf.vals&graph chng&re-scale (3)Press TAB x3,type,use cursor,del,bksp.Ins&try more; see Status Bar(bottom of Frame)"
  Text(_ap(Val(reslt$)))=""
  'Text(_ap(6))=x
  Text(_ap(Val(reslt$)))=x
  
End Sub
Sub Init
 ? "Profiling system...."
 SetTickPerformance
 ' Register the classes
 Local As INTEGER clsID
 Local As STRING eReslt
 Register "Frame",clsID: CT_FRAME=clsID
 Register "TextBox",clsID: CT_TEXTBOX=clsID
 Register "Label",clsID: CT_LABEL=clsID
 Register "F-Keys",clsID: CT_F_KEYS=clsID
 ? "Native Classes all registered"
 InitControls
 ' Screen Resize/refresh parameters
 Dim As INTEGER CurrW=0
 Dim As INTEGER PrevW=-1
 Dim As INTEGER CurrH=0
 Dim As INTEGER wt
 Dim As INTEGER OldTimer=0
 Dim i%
 'Cursor
 Dim As Integer flash%
 
'Performance Class
Dim As INTEGER PF_StartupTime=10 'Wait time before setting minimum
Dim As INTEGER PF_PTS=255
Dim As INTEGER PF_data(PF_PTS)
Dim PF_timer%=Timer+1000
Dim PF_Idle%, PF_Max%=1,PF_Min%=999999 ' Base Scan cycle Loop idle 
Dim PF_UpTime%
Register "TS",clsID
'CT_cnt=CT_cnt+1
Const CT_TS=clsID 'CT_cnt
Dim TS_scrtimer%=125*(Timer\125+7) ' next second
Dim As INTEGER TS_mode=1 ' initially slow scroll
'Dim As INTEGER ac 'scroller
Dim As INTEGER TS_sb=0
'Dim xx$
Dim As INTEGER TS_cnt,TS_prevcnt,TS_prevtime
Register "MB",clsID
'CT_cnt=CT_cnt+1
Const CT_MB=clsID 'CT_cnt
Dim scrtimer%=125*(Timer\125+7) ' next second
Dim As INTEGER MB_mode=1 ' initially slow scroll
Dim As INTEGER ac 'scroller
Dim As INTEGER MB_sb=0
Dim xx$
Dim As INTEGER MB_cnt,MB_prevcnt,MB_prevtime
'keyscan
Dim KY_k$ ' KEY PRESSED
End Sub
'**************** Execution starts here ********************
 ' ? "About to run 'SMT_Test.APP'"
 ' ? "Press any key to continue (^C to abort)";
 ' Do:Loop While Inkey$=""
 ' ?
Init
 'Main procedure
Sub PF_Update
 Local i%
 'Process  (and Status Bar)
  If ovr% Then _sb(1)="OVR" Else _sb(1)="INS"
  _sb(1)=_sb(1)+Chr$(219)+"CurrX:"+Str$(_cx(CurrCtl))+Chr$(219)+"CurrY:"+Str$(_cy(CurrCtl))+Chr$(219)+"CurrCtl:"+Str$(CurrCtl)
  DrawSB(1)
  'performance for 1 second
  If PF_Idle%>PF_Max% Then
PF_Max%=PF_Idle%
  Else
    If PF_UpTime%<PF_StartupTime then
PF_Min%=PF_Idle%
    Else
      If PF_Min%>PF_Idle% Then PF_Min%=PF_Idle%
    EndIf
  EndIf
  For i%=1 to PF_PTS
PF_data(i%-1)=PF_data(i%)
  Next i%
PF_data(PF_PTS)=PF_idle%
  If _w(6)>PF_PTS Then _w(6)=PF_PTS
  Text(5)=""
    For i%=PF_PTS-_w(6)+1 to PF_PTS
      'If i%>PERF_PTS Then Exit For  'too long - whole thing needs rebuilding -this is a kludge
      Select Case PF_data(i%)/PF_Max%
      Case Is > .9: Text(5)=Text(5)+Chr$(95)
      Case Is > .8: Text(5)=Text(5)+Chr$(242)
      Case Is > .4: Text(5)=Text(5)+Chr$(220)
      Case Else: Text(5)=Text(5)+Chr$(219)
      End Select
    Next i%
  _sb(6)="Scan/s:"+Str$(PF_idle%)+" Max:"+Str$(PF_Max%)+" Min:"+Str$(PF_Min%)+" Instr/s="+Str$(giIPS)+" Ticks/s="+Str$(giTickRate)+" Uptime="+Str$(PF_Uptime%)+"."
  DrawFrame 6
PF_idle%=0
  Cursor MMHRES,MM.VRES
PF_timer%=PF_timer%+1000
PF_UpTime%=PF_Uptime%+1
End Sub
Sub KY_Update
    Select Case Asc(KY_k$)
      Case K_F6:PrevW=-1 'Force RePaint
      Case K_F12
        Colour 7,0
        Cursor 1,MM.VRES-3
        Do
          ? "About to Quit MM Basic are you sure (Y=Quit) (N=Don't Quit) (<ESC> = exit to MM Dos prompt): "; :
          Do: KY_k$=Inkey$: Loop While KY_k$=""
          Select Case Ucase$(KY_k$)
            Case Chr$(K_ESC):END
            Case "Y": Quit
            Case "N"
              Cursor 1,MM.VRES-3
              ? Space$(92);
              Exit Do
            Case Else: ? BEL;
          End Select
        Loop
      Case K_F2: TS_mode=-TS_mode
      Case K_F3: If ABS(TS_mode)=2 Then TS_mode=TS_mode/2 Else TS_mode=TS_mode*2: EndIf
      Case K_TAB: FocusNextControl 'within frame
      CASE K_INS: ovr%=NOT(ovr%) ' Insert Mode
      Case Else: KeyPress KY_k$
    End Select
End Sub
Sub TS_Update(ctlID As INTEGER)
  Local As INTEGER txtID=_ap(ctlID)
TS_cnt=TS_cnt+1
  Text(txtID)=Mid$(Text(txtID),2)+Left$(Text(txtID),1)
  DisplayStr ctlID  ' maybe just set a flag for this, and use tick process to schedule screen update.
  If TS_mode=1 Then TS_scrtimer%=TS_scrtimer%+125
End Sub
Function TS_Create(odef As STRING) As STRING
TS_Create=Create(odef)
End Function
Sub MB_Update(ctlID As INTEGER)
  Local As INTEGER txtID=_ap(ctlID)
MB_cnt=MB_cnt+1
  Text(txtID)=Mid$(Text(txtID),2)+Left$(Text(txtID),1)
  DisplayStr ctlID  ' maybe just set a flag for this, and use tick process to schedule screen update.
  If MB_mode=1 Then scrtimer%=scrtimer%+125
End Sub
Function MB_Create(odef As STRING) As STRING
MB_Create=Create(odef)
End Function
' In here we need a hook to calling application's instantiation code ...but maybe not anymore...
Sub TickerTasks
 'Resize/re-paint if necessary
  If PrevW<>MM.HRES Or CurrH<>MM.VRES Then
    Cls
    PrevW=ScreenDimChanged()
    CurrW=MMHRES-1
    CurrH=MM.VRES
    PrevW=MM.HRES
    wt=Timer+500
  ElseIf wt>0 And wt<Timer Then 'if last section run in this tick, 'twould be a bit greedy to run this section this tick
    _dw(CurrFrame)=CurrW-1
    _dh(CurrFrame)=CurrH-1
    RePaint
    Text(4)=Str$(CurrW,6)+Str$(CurrH,6)
    DisplayStr 5
    wt=0
  EndIf
  'Cursor Flash
  If flash%=0 And (Timer Mod 750)>374 And CurrCtl>0 Then 'Flash character
    Cursor _cx(CurrCtl),_cy(CurrCtl)
    Colour _cf(CurrCtl),_cb(CurrCtl)
    ? Mid$("_"+Chr$(219),ovr%+1,1); 'underscore represents Insert mode, solid block represents Overwrite mode
    flash%=1
   ElseIf flash%=1 And CurrCtl>0 And (Timer Mod 750)<375 Then 'Normal character
    Cursor _cx(CurrCtl),_cy(CurrCtl)
    Colour _cf(CurrCtl),_cb(CurrCtl)
    ? Chr$(_cc(CurrCtl));
    flash%=0
  EndIf
  Cursor MMHRES,MM.VRES
  If PF_timer%<=Timer Then PF_Update
  If TS_mode=1 And TS_scrtimer%<Timer Then TS_Update 3  'To be fixed
  If Timer Mod 1000<500 Then
    If TS_sb Then  ' And If TS_cnt<>TS_prevcnt Then
TS_sb=0
      _sb(3)=Str$(TS_cnt)+" cyc,"+Str$((TS_cnt-TS_prevcnt)\(Timer\1000-TS_prevtime))+" cps"
TS_prevcnt=TS_cnt
TS_prevtime=Timer\1000
      DrawSB 3
    EndIf
  Else
TS_sb=1
  EndIf
  If MB_mode=1 And scrtimer%<Timer Then MB_Update 3  'To be fixed
  If Timer Mod 1000<500 Then
    If MB_sb Then  ' And If MB_cnt<>MB_prevcnt Then
MB_sb=0
      _sb(3)=Str$(MB_cnt)+" cyc,"+Str$((MB_cnt-MB_prevcnt)\(Timer\1000-MB_prevtime))+" cps"
MB_prevcnt=MB_cnt
MB_prevtime=Timer\1000
      DrawSB 3
    EndIf
  Else
MB_sb=1
  EndIf
KY_k$=Inkey$:If KY_k$<>"" Then KY_Update
  OldTimer=Timer
End Sub
Do ' Base scan loop
  If Timer<>OldTimer Then TickerTasks 'at least 64 times a second (Win 7,8& 10)
  If TS_mode=2 Then TS_Update ' scroller TextBox 2 FAST task If natively inBase loop runs twice as fast
  If MB_mode=2 Then MB_Update ' scroller TextBox 2 FAST task If natively inBase loop runs twice as fast
PF_idle%=PF_idle%+1
Loop
Quit
'For the future MM auto-detect, chat, code test, file edit,... IDE???
